USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_RecordUserRefundedPoints]    Script Date: 8/27/2013 2:33:00 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-29>
-- Description:	<Record user getting a refund>
-- =============================================
CREATE PROCEDURE [dbo].[RP_RecordUserRefundedPoints]
	@userID int, @amount money, @orderID int, @errorMessage varchar(max) OUTPUT
AS
DECLARE @returnCode int = 1, @fullMatchingRecordID int, @semiMatchingRecordID int, @checkSpentAmount money
		,@fullMatchingOrder int, @semiMatchingOrder int
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be non-committable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';

	-- just make sure it is positive
	SET @amount = (-1)*SIGN(@amount)*@amount*(-1);

	-- get the neg amount to find the spent record
	SET @checkSpentAmount = (-1)*SIGN(@amount)*@amount;

	-- look for a matching record, if there is one return already exist or something
	SELECT @fullMatchingRecordID = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and Type = 6 and PointChange = @amount);
	SELECT @semiMatchingRecordID = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and Type = 6 and PointChange != @amount);

	-- make sure this user bought this order and it is the amount matches
	SELECT @fullMatchingOrder = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and Type = 5 and PointChange = @checkSpentAmount);
	SELECT @semiMatchingOrder = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and Type = 5 and PointChange != @checkSpentAmount);
	
	-- YES going to see some HOLY MOLLY NESTED IF's
	IF @semiMatchingRecordID IS NOT NULL
		BEGIN
		SELECT @returnCode = 200;
		SELECT @errorMessage = 'Refund Completed already with different amount';
		--print 'Refund Completed already with different amount';
		END;
	ELSE IF @semiMatchingOrder IS NOT NULL
		BEGIN
		SELECT @returnCode = 202;
		SELECT @errorMessage = 'Order and User found but amount different';
		--print 'Order and User found but amount different';
		END;
	ELSE IF @fullMatchingOrder IS NULL
		BEGIN
		SELECT @returnCode = 203;
		SELECT @errorMessage = 'No matching order with that amount userID and orderID';
		--print 'No matching order with that amount userID and orderID';
		END;
	ELSE IF @fullMatchingRecordID IS NOT NULL
		BEGIN
		SELECT @returnCode = 201;
		SELECT @errorMessage = 'Refunded already';
		--print 'Refunded already';
		END;
	ELSE
		BEGIN
			BEGIN TRY
				BEGIN TRANSACTION;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
				INSERT INTO [dbo].[RewardTransaction] 
				(UserID
				,OrderID
				,DateCreated
				,PointChange
				,Type)
				Values
				(@userID
				,@orderID
				,GETUTCDATE()
				,@amount
				,6);
				COMMIT TRANSACTION;
			END TRY
			BEGIN CATCH
				ROLLBACK TRANSACTION;
				SELECT @returnCode = 900;
				SELECT @errorMessage = ERROR_MESSAGE();
			END CATCH;
		  
		END;
	RETURN @returnCode;
END

GO


